package com.ejie.p06b.dao;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B42T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (01/07/2011)
 */
public class P06B42T00DAO {
	
	static private P06B42T00DAO instance = null;

	public static P06B42T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B42T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B42T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene la lista de justificantes asociados a la DEC del expediente
    * @param ejer.
    * @param numExp.         
    * @return Lista de objetos de documentos de la DEC
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B42T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B42T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	byte[] doc = null;
	    		ByteArrayOutputStream bos = new ByteArrayOutputStream();
	    		InputStream is = null;
	    		
	        	obj = new P06B42T00Datatype();
	        	
	        	obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B42_EJERCICIO));
	        	obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B42_NUMEXP));
			    obj.setIndFich(lrst.getString(P06BTablas.P06B_P06B42_INDFICH));
			    obj.setFecha(lrst.getString(P06BTablas.P06B_P06B42_FECHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B42_FECHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setTitulo(lrst.getString(P06BTablas.P06B_P06B42_TITULO)==null?"":lrst.getString(P06BTablas.P06B_P06B42_TITULO));
			    obj.setTipo(lrst.getString(P06BTablas.P06B_P06B42_TIPO)==null?"":lrst.getString(P06BTablas.P06B_P06B42_TIPO));
			    
			    //Descargar el dato de tipo BLOB
				is = lrst.getBinaryStream(P06BTablas.P06B_P06B42_DOCUMENTO);
				if (is != null ){
					int leido = -1;
					while ((leido = is.read()) != -1 ){
						bos.write( leido );
					}
					doc = bos.toByteArray();
				}
				obj.setDocumento(doc);
				
				obj.setCifNifEnvio(lrst.getString(P06BTablas.P06B_P06B42_CIFNIF_ENVIO)==null?"":lrst.getString(P06BTablas.P06B_P06B42_CIFNIF_ENVIO));
				
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B42T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}

	
	private static String SELECTALL_BY_EJEREXP =
		"SELECT " +
		P06BTablas.P06B_P06B42_EJERCICIO + "," +
		P06BTablas.P06B_P06B42_NUMEXP + "," +
		P06BTablas.P06B_P06B42_INDFICH + "," +
		P06BTablas.P06B_P06B42_FECHA + "," +
		P06BTablas.P06B_P06B42_TITULO + "," +
		P06BTablas.P06B_P06B42_TIPO + "," +
		P06BTablas.P06B_P06B42_DOCUMENTO + "," +
		P06BTablas.P06B_P06B42_CIFNIF_ENVIO + 
		" FROM " + P06BTablas.P06B_P06B42T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B42_EJERCICIO + "= ?"
		+ " AND " + P06BTablas.P06B_P06B42_NUMEXP + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B42_INDFICH;
	
}
